// Currency.cpp : Defines the entry point for the DLL application.
//

#include "StdAfx.h"
#include "Interface.h"

/*****************************************************************************

             
    (www.cbr.ru)   AbilityCash (http://www.dervish.ru).

       AbilityCash  
  ,         :

  1. AbilityCash        
       .        
      ,  ,    , 
          .

  2.       (), 
         -      
       .

  3.   ()      ,
             
       AbilityCash.

           
    : HTML  XML.       
     XML.

    XML-    XML-, 
      :     
      .

*****************************************************************************/

// ---   ------------------------------------------------------

//     
#define MAX(x,y)	((x) > (y) ? (x) : (y))

//     
#define MIN(x,y)	((x) < (y) ? (x) : (y))

//     
#define DIM(x)		(sizeof(x) / sizeof((x)[0]))

// ---------------------------------------------------------------------------
// ---    -----------------------------------------------
// ---------------------------------------------------------------------------

//   ALibraryInfo .    "Interface.h"

const static ALibraryInfo TheLibraryInfo = {
	//   -     .
	sizeof(ALibraryInfo),

	//       
	//   .
	1251,

	//   .     
	//  .       
	//  .
	"   (XML-)",

	//  ,    .   
	//   http,  (!)       
	//    "http://",    , 
	//    .       
	//      "www.cbr.ru"    212.40.192.49
	"212.40.192.49", //   ,   "www.cbr.ru",

	//  ,       ,  
	//       ,    .
	//        
	//    .
	"RUR", " ",

	//   .       
	//       , , , 
	//  .
	"Dervish",

	//     . ,  
	//  e-mail.
	"serg@dervish.ru",

	//    . ,   URL  
	"http://www.dervish.ru"
};

//  GetLibraryInfo       
//   .     ,  
// .
LPCLIBINFO __stdcall GetLibraryInfo (void) {
	return & TheLibraryInfo;
}

// ---------------------------------------------------------------------------
// ---    --------------------------------------------------
// ---------------------------------------------------------------------------

//         .   
//      .    
//        . ,  
//    ,       
//    ,  .      
//  URL  .    URL  
//   .       
//  (  ),       
//  GetResources (.).

//  ,        
// (www.cbr.ru),      ,   
//     .

static const char szDaily[] = "/scripts/XML_daily.asp?date_req=%2.2d/%2.2d/%4.4d&d=0";
static const char szMonthly[] = "/scripts/XML_daily.asp?date_req=01/%2.2d/%4.4d&d=1";

//  ,   AbilityCash     ( -
// ),        .
//          
// GetResources    AbilityCash.

//          ,
// ,       
//  .      (   
//    ),    ,
// AbilityCash      
// .

#define ESTIMATE_DAY	(2900)
#define ESTIMATE_MON	(17500)

//  GetResources   AbilityCash  ,  
//   (),       .
//         
//     .
//   AbilityCash      URL 
//   ,      
// . ,   -  ,    
//      ,    
//  .

void __stdcall GetResources (ARateDate date, LPCALLBACK pCallback) {
	AResource Resource;
	char szBuffer [ 2 * MAX(sizeof(szDaily), sizeof(szMonthly)) ];

	memset (& Resource, 0, sizeof(Resource));

	Resource.dwStructSize  = sizeof(Resource);
	Resource.lpResourceURL = szBuffer;

	// ,  
	wsprintf (szBuffer, szDaily, date.iDay, date.iMonth, date.iYear);
	Resource.date = date;
	Resource.dwEstimateSize = ESTIMATE_DAY;
	Resource.dwContext = 0;
	pCallback->QueueResource (& Resource);

	// ,  
	wsprintf (szBuffer, szMonthly, date.iMonth, date.iYear);
	Resource.date.iDay = 1;
	Resource.dwEstimateSize = ESTIMATE_MON;
	Resource.dwContext = 1;
	pCallback->QueueResource (& Resource);
}

// ---------------------------------------------------------------------------
// ---       ------------------------
// ---------------------------------------------------------------------------
//   ,      .
//        ,   
//   ,       .


// FindTag -     .   ,  
//          .
bool FindTag (LPCSTR pString, int & iStart, int & iLength) {

	iStart = iLength = 0;

	//  ,  
	for (; *pString != 0; pString++, iStart++) {
		if (*pString == '<')
			break;
	}
	if (*pString == 0)
		return false;
	pString += 1;

	//    
	for (; *pString != 0; pString++, iLength++) {
		if (*pString == '>')
			break;
	}
	if (*pString == 0)
		return false;

	iLength += 2;	//     '<', '>'
	return true;
}

// FindTagAttr -       .
//      pString   -      ,    
//                   .
//      iLength   -    .
//      pAttrName -   
//      pResult   -  ,     
//                   .
bool FindTagAttr (LPCSTR pString, int iLength, LPCSTR pAttrName, LPCSTR & pResult) {
	LPCSTR pScan;

	pResult = NULL;

	//   
	for (; iLength > 0; iLength--, pString++) {
		if (isspace(*pString))
			break;
	}

	//          ,   
	//   ,      , 
	//      .
	while (iLength > 0) {

		//   
		while (isspace(*pString) && iLength > 0)
			pString++, iLength--;

		// ,    
		if (iLength <= 0)
			break;

		//      
		for (pScan = pAttrName; iLength > 0; pString++, pScan++, iLength--) {
			if (*pScan == 0) {
				//      ,  
				//   ,    
				//   
				if (*pString == '=') {
					// , .   ,   
					pResult = pString + 1;
					return true;
				}
				// ,  .      
				//    .   
				break;
			}
			//     ,   ,  
			// ,   
			if (*pScan != *pString)
				break;
			//      ,  ,   
			// ,   .    .
			if (*pString == '=')
				break;
		}

		// ,    .
		if (iLength <= 0)
			break;

		//    
		while (iLength > 0 && (! isspace(*pString)) && (*pString != '='))
			pString++, iLength--;

		// ,    .
		if (iLength <= 0)
			break;

		//      ,    .
		if (*pString == '=') {
			pString++, iLength--;
			if (iLength == 0)
				break;
			if (*pString == '"' || *pString == '\'') {
				char cQuot = *pString;
				//    .
				//      
				do
					pString++, iLength--;
				while (iLength > 0 && *pString != 0 && *pString != cQuot);
				pString++, iLength--;
			} else {
				//   .      
				while (iLength > 0 && ! isspace(*pString))
					pString++, iLength--;
			}
		}
	}

	return false;
}

//  ReadInt     , 
//       ,
//   .
int ReadInt (LPCSTR & pString) {
	int iResult = 0;

	while (isdigit(*pString))
		iResult = iResult * 10 + (*pString++) - '0';

	return iResult;
}

// ReadValue        
//  .
__int64 ReadValue (LPCSTR pString, int iLength) {
	int     i, iFraction = 0;
	__int64 iInteger = 0;

	//     .
	for (; iLength > 0; iLength--, pString++) {
		if (! isdigit(*pString))
			break;
		iInteger = 10 * iInteger + (*pString) - '0';
	}

	//     ,  .
	if (*pString == ',') {
		pString++, iLength--;

		for (i = 0; i < 4 && iLength > 0; i++, pString++, iLength--) {
			if (! isdigit(*pString))
				break;
			iFraction = iFraction * 10 + (*pString) - '0';
		}
		for (; i < 4; i++)
			iFraction *= 10;
	}

	//     :   
	//     ,   
	//  .
	return 10000 * iInteger + iFraction;
}

// ReadDate -    .     
//       .
void ReadDate (ARateDate & date, LPCSTR pString) {
	memset (& date, 0, sizeof(date));

	date.iDay = ReadInt (pString);
	pString += 1;

	date.iMonth = ReadInt (pString);
	pString += 1;

	date.iYear = ReadInt (pString);
}

//  FinTagContents       
//         .
// :  <tag>Contents</tag>       
// "Contents".
//
//
bool FindTagContents (
	LPCSTR   pString,		//  .
	int      iStrLength,	//   .
	LPCSTR   pTagName,		//   ( tag   <tag>  </tag>
	int    & iStart,		//    
	int    & iLength)		//   
{
	int iTagNameLength, iTagStart, iTagLen;
	LPCSTR pScan;

	iTagNameLength = lstrlen(pTagName);
	pScan = pString;

	//    
	while (pScan < pString + iStrLength) {
		if (! FindTag (pScan, iTagStart, iTagLen))
			return false;
		pScan += iTagStart + 1;
		if (memcmp (pScan, pTagName, iTagNameLength) != 0)
			continue;
		if (isspace(pScan[iTagNameLength]) || pScan[iTagNameLength] == '>')
			break;
	}

	iStart = (pScan - pString) + iTagLen - 1;

	//    
	while (pScan < pString + iStrLength) {
		if (! FindTag (pScan, iTagStart, iTagLen))
			return false;
		pScan += iTagStart + 1;
		if (*pScan != '/')
			continue;
		if (memcmp (pScan + 1, pTagName, iTagNameLength) != 0)
			continue;
		if (pScan[iTagNameLength + 1] == '>')
			break;
	}

	iLength = (pScan - pString) - iStart - 1;

	return true;
}

// ---------------------------------------------------------------------------
// ---      -----------------------------------
// ---------------------------------------------------------------------------

/*
    FetchRates       
     .      .

              :

	<?xml version="1.0" encoding="windows-1251" ?>
	<ValCurs Date="29/05/2004" name="Foreign Currency Market">
		<Valute ID="R01235">
			<NumCode>840</NumCode>
			<CharCode>USD</CharCode>
			<Nominal>1</Nominal>
			<Name> </Name>
			<Value>28,9850</Value>
		</Valute>
		<Valute ID="R01239">
			<NumCode>978</NumCode>
			<CharCode>EUR</CharCode>
			<Nominal>1</Nominal>
			<Name></Name>
			<Value>35,6052</Value>
		</Valute>
	</ValCurs>

*/

void __stdcall FetchRates (LPCSTR pResource, DWORD dwContext, LPCALLBACK pCallback) {
	int       iStart, iLength, iValStart, iValLength, iFields;
	char      szName [128], szCode [128];
	LPCSTR    pDate;
	ARateInfo Rate;

	memset (& Rate, 0, sizeof(Rate));

	//    ,    
	//     .
	Rate.pName = szName;
	Rate.pCode = szCode;

	iStart = iLength = 0;

	//       <?xml ... ?>
	if (! FindTag (pResource, iStart, iLength))
		return;
	pResource += iStart + iLength;

	//      ValCurs,   
	//   ,      
	//  .
	if (! FindTag (pResource, iStart, iLength))
		return;
	pResource += iStart;

	//    ValCurs      "Date".
	//       .
	if (! FindTagAttr (pResource, iLength, "Date", pDate))
		return;
	ReadDate (Rate.date, pDate + 1);
	pResource += iLength;

	//         <Valute></Valute>, 
	//        (,  )   ,
	//     .
	while (FindTagContents (pResource, lstrlen(pResource), "Valute", iStart, iLength)) {

		//       
		//  <Valute></Valute>
		pResource += iStart;

		//         ,
		//    .
		iFields = 0;

		//     
		if (FindTagContents (pResource, iLength, "CharCode", iValStart, iValLength)) {
			iValLength = MIN(iValLength, DIM(szCode) - 1);
			memcpy (szCode, pResource + iValStart, iValLength);
			szCode[iValLength] = 0;
			iFields += 1;
		}

		//   
		if (FindTagContents (pResource, iLength, "Name", iValStart, iValLength)) {
			iValLength = MIN(iValLength, DIM(szName) - 1);
			memcpy (szName, pResource + iValStart, iValLength);
			szName[iValLength] = 0;
			iFields += 1;
		}

		//   "Nominal".     
		//  ,   
		// ,    "Value" (.).
		if (FindTagContents (pResource, iLength, "Nominal", iValStart, iValLength)) {
			Rate.iValue2 = ReadValue (pResource + iValStart, iValLength);
			iFields += 1;
		}

		//   "Value".     
		//  ,   
		// ,    "Nominal" (.).
		if (FindTagContents (pResource, iLength, "Value", iValStart, iValLength)) {
			Rate.iValue1 = ReadValue (pResource + iValStart, iValLength);
			iFields += 1;
		}

		//     , 
		//   
		if (iFields == 4)
			pCallback->InsertRate (& Rate);

		//      
		pResource += iLength;
	}

}

// ---------------------------------------------------------------------------
// --- DllMain -      --------------------------
// ---------------------------------------------------------------------------

//      ,    
//  ,      .

BOOL APIENTRY DllMain (HANDLE, DWORD, LPVOID) {
	return TRUE;
}
