#pragma once

/*****************************************************************************

  Interface.h -  ,      ,
            
  .

          
  AbilityCash:

  1.   AbilityCash     
     .      DllMain,  
          ( 
     ).

  2.  AbilityCash     , 
       ,      
         .    
        ( ,   ),
        ,     
      .

         AbilityCash  
     GetLibraryInfo,     ALibraryInfo,
        .

       ALibraryInfo   GetLibraryInfo 
        .

  3.   AbilityCash     GetResources,
         AbilityCash ( callback-)
       ,  ,   
     .

     GetResources     callback- ,
              
     ,  AbilityCash     
      .      
     ,    AbilityCash   
          FetchRates.

  4.     AbilityCash   FetchRates 
        .   FetchRates  
      (zero-terminated)     .

     FetchRates     ,   
            ( callback-) 
     AbilityCash.

     FetchRates     callback- ,
               
      ,  AbilityCash    
     .

  5.  ,      , AbilityCash
         .    
     DllMain,        
      .

          , 
      .

*****************************************************************************/

// ---------------------------------------------------------------------------
// --- ACallback -   AbilityCash -------------------------
// ---------------------------------------------------------------------------
//   ,  callback-  .

struct  ACallback;
typedef ACallback * LPCALLBACK;

// ---------------------------------------------------------------------------
// --- ALibraryInfo -   ------------------------------
// ---------------------------------------------------------------------------
// ALibraryInfo    ,   
//     ,    ,
//   AbilityCash      .

struct ALibraryInfo {
	// cbSize -    ALibraryInfo.   , 
	//  AbilityCash     
	//        .
	DWORD  cbSize;

	// uiCodePage -   ,   .
	//     ,     
	//    ,    .
	//         1251.
	UINT   uiCodePage;

	// szProviderName -   .     
	//     .    
	//  -,       
	//  . : "   ".
	LPCSTR szProviderName;

	// szProviderSite -        
	//  ,      .  
	// AbilityCash    HTTP,     
	//    . : "www.cbr.ru", "212.40.192.49"
	// !       , AbilityCash
	//    .    
	//  : "http://www.cbr.ru", "ftp://212.40.192.49"
	LPCSTR szProviderSite;

	// szBaseCurrencyCode -   (  ) .
	//  ,       
	//      .   
	//          , ,
	// ,     .   
	//     AbilityCash   
	//   ,   szBaseCurrencyCode  
	//   . ,    
	//           "RUR".
	LPCSTR szBaseCurrencyCode;

	// szBaseCurrencyName -   (  ) .
	//       ,   .   
	//           
	// " ".
	LPCSTR szBaseCurrencyName;

	// szAuthor -       ,  
	//       .
	LPCSTR szAuthor;

	// szAuthorMail -        
	//  .
	LPCSTR szAuthorMail;

	// szAuthorSite -        .
	LPCSTR szAuthorSite;
};

typedef const ALibraryInfo * LPCLIBINFO;

// GetLibraryInfo -      ALibraryInfo,
//   AbilityCash      .
extern "C" LPCLIBINFO __stdcall GetLibraryInfo (void);

typedef LPCLIBINFO (__stdcall * GETLIBINFOPROC) (void);

// ---------------------------------------------------------------------------
// --- ARateDate -     --------------------------------
// ---------------------------------------------------------------------------

//  ARateDate  .    
//  ,      .
struct ARateDate {
	__int16 iYear;      //      
	__int8  iMonth;     //      (1..12)
	__int8  iDay;       //       (1..31)
};

// ---------------------------------------------------------------------------
// --- AResource -   -----------------------------------------
// ---------------------------------------------------------------------------

// AResource       .
struct AResource {

	// dwStructSize -   .
	DWORD dwStructSize;

	// date -  ,     .
	ARateDate date;

	// dwEstimateSize -    HTML-  .
	//     ,    
	//        -.
	// AbilityCash    ,     
	//    ,      
	//   ,      .
	//        .
	DWORD dwEstimateSize;

	// dwContext -   ,   
	//    .    
	//         .
	DWORD dwContext;

	// lpResourceURL -    .   
	//  URL,       
	//     . ,  
	//     :
	//    http://www.cbr.ru/scripts/XML_daily.asp?date_req=01/10/2003&d=0
	//      :
	//                     /scripts/XML_daily.asp?date_req=01/10/2003&d=0
	LPSTR lpResourceURL;
};

// GetResources -      
//      .      
//  ,       ,  
//       ,   
//   QueueResource   .
//
//  GetResources    ,    
//        QueueResource.
//
// GetResources       
// ,  QueueResource    
//   .
extern "C" void __stdcall GetResources (ARateDate, LPCALLBACK);

typedef void (__stdcall * GETRESOURCESPROC) (ARateDate, LPCALLBACK);

// ---------------------------------------------------------------------------
// --- ARateInfo -     ----------------------------------
// ---------------------------------------------------------------------------

// ARateInfo   ,      
//   , ,   .
//         
// AbilityCash     FetchRates.
struct ARateInfo {

	// iValue1 -    .  4 
	//     ,     
	//   . ,  iValue1  "123456789",
	//      "12 345,6789".
	__int64   iValue1;

	// iValue2 -    .  
	//    ,   iValue1
	__int64   iValue2;

	// pCode -   ,   .
	LPCSTR    pCode;

	// pName -   ,   .
	LPCSTR    pName;

	// date -     .
	ARateDate date;
};

// FetchRates -   AbilityCash    
//    .      
//  ,   ,   .
//     ,  AbilityCash 
//  .        ,
//       AbilityCash   
// .
extern "C" void __stdcall FetchRates (LPCSTR pResource, DWORD dwContext, LPCALLBACK);

typedef void (__stdcall * FETCHRATESPROC) (LPCSTR, DWORD, LPCALLBACK);

// ---------------------------------------------------------------------------
// --- ACallback -   AbilityCash -------------------------
// ---------------------------------------------------------------------------

//  ACallback    GetResources  FetchRates 
// ,       AbilityCash  .

struct ACallback {

	// QueueResource -       . 
	//       GetResources  
	//         FetchRates.
	//    QueueResource   , 
	//         (    
	// ) ,     .
	virtual void QueueResource (const AResource *) = 0;

	// InsertRate -    .    
	//    FetchRates        
	// GetResources.
	virtual void InsertRate (const ARateInfo *) = 0;

};
